#pragma once //load this header file only once in the application

/**
 * uart.h Header File for UART Communication on the
 * STM32F103RB Nucleo Board
 *
 * @Author: Nicolas Dammin, 2016
 *
 */

#include "stm32f10x.h"

/**
 * Configuration Area
 */
#define USART_PORT			GPIOA
#define USART_Port_Periph	RCC_APB2Periph_GPIOA
#define RX_Pin				GPIO_Pin_3
#define TX_Pin				GPIO_Pin_2

#define USART_Periph		RCC_APB1Periph_USART2
#define USART_BASE 			USART2

void usart_init(uint32_t baudrate);
void usart_sendChar(char c);
void usart_sendText(char *t);
char usart_getChar();
void usart_sendNumber(uint32_t number);
