/**
 * Timer and Interrupt example program for STM32F103 Nucleo
 *
 * @Author: Nicolas Dammin, 2016
 */
#include "stm32f10x.h"
#include "GPIO.h"

extern uint32_t time;

void Delay(uint32_t wait) {
	uint32_t current_time = time;

	while(time < current_time+wait);
}

int main(void)
{
	RCC_ClocksTypeDef clocks;
	TIM_TimeBaseInitTypeDef TIM_Struct;
	TIM_OCInitTypeDef OC_Struct;
	NVIC_InitTypeDef NVIC_Struct;

	RCC_GetClocksFreq(&clocks);

	SysTick_Config(clocks.SYSCLK_Frequency / 1000);

	pinMode(D2, OUTPUT);
	pinMode(D4, OUTPUT);

	RCC_APB2PeriphClockCmd(RCC_APB2Periph_TIM1, ENABLE);

	NVIC_Struct.NVIC_IRQChannel = TIM1_CC_IRQn;
	NVIC_Struct.NVIC_IRQChannelPreemptionPriority = 0;
	NVIC_Struct.NVIC_IRQChannelSubPriority = 1;
	NVIC_Struct.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_Struct);

	uint16_t Prescaler = (uint16_t)(clocks.SYSCLK_Frequency/12000000)-1;

	TIM_Struct.TIM_CounterMode = TIM_CounterMode_Up;
	TIM_Struct.TIM_ClockDivision = 0;
	TIM_Struct.TIM_Prescaler = 0;
	TIM_Struct.TIM_Period = 65535;
	TIM_TimeBaseInit(TIM1, &TIM_Struct);

	TIM_PrescalerConfig(TIM1, Prescaler, TIM_PSCReloadMode_Immediate);

	OC_Struct.TIM_OCMode = TIM_OCMode_Timing;
	OC_Struct.TIM_OCPolarity = TIM_OCPolarity_High;
	OC_Struct.TIM_Pulse = 6000;
	OC_Struct.TIM_OutputState = TIM_OutputState_Enable;
	TIM_OC1Init(TIM1, &OC_Struct);

	TIM_OC1PreloadConfig(TIM1, TIM_OCPreload_Disable);

	TIM_ITConfig(TIM1, TIM_IT_CC1, ENABLE);
	TIM_Cmd(TIM1, ENABLE);

    while(1)
    {
    	digitalWrite(D2, 1);
    	Delay(1000);

    	digitalWrite(D2, 0);
    	Delay(1000);
    }
}
