#include "stm32f10x.h"

void sendChar(char c) {
	USART_SendData(USART2, c);
	while(!USART_GetFlagStatus(USART2, USART_FLAG_TC));
}

void sendText(char *t) {
	while(*t != 0) {
		sendChar(*t);
		t++;
	}
}

int main(void)
{
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA | RCC_APB2Periph_AFIO, ENABLE);
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART2, ENABLE);

	GPIO_InitTypeDef GPIO_Struct;
	USART_InitTypeDef USART_Struct;

	GPIO_Struct.GPIO_Pin = GPIO_Pin_3;
	GPIO_Struct.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	GPIO_Init(GPIOA, &GPIO_Struct);

	GPIO_Struct.GPIO_Pin = GPIO_Pin_2;
	GPIO_Struct.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_Struct.GPIO_Speed = GPIO_Speed_10MHz;
	GPIO_Init(GPIOA, &GPIO_Struct);

	USART_Struct.USART_BaudRate = 9600;
	USART_Struct.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
	USART_Struct.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;
	USART_Struct.USART_Parity = USART_Parity_No;
	USART_Struct.USART_WordLength = USART_WordLength_8b;
	USART_Struct.USART_StopBits = USART_StopBits_1;
	USART_Init(USART2, &USART_Struct);

	USART_Cmd(USART2, ENABLE);

	//uint32_t count = 0;
	char x;

    while(1)
    {
    	if(USART_GetFlagStatus(USART2, USART_FLAG_RXNE)) {
    		x = USART_ReceiveData(USART2);
    		USART_ClearFlag(USART2, USART_FLAG_RXNE);
    		x++;
    		sendChar(x);
    	}
    }
}
